unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, LconvEncoding, LCLProc;
type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: char);
    procedure CyrillicSearch;
    procedure FormShow(Sender: TObject);
    procedure Memo1KeyPress(Sender: TObject; var Key: char);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.CyrillicSearch;
var
  k: integer;
  text_UTF8, str_UTF8: string;
begin
  Edit1.SetFocus;
  if Edit1.Text= '' then
  begin
    ShowMessage('Введите строку для поиска');
    exit;
  end;
  text_UTF8:= UTF8Copy(UTF8Decode(Memo1.Text), Memo1.SelStart + 1 +
              Memo1.SelLength, UTF8Length(UTF8Decode(Memo1.Text)) -
              Memo1.SelStart - Memo1.SelLength);
  str_UTF8:= UTF8Decode(Edit1.Text);
  k:= UTF8Pos(str_UTF8, text_UTF8);
  if k > 0 then
  begin
    Memo1.SetFocus;
    Memo1.SelStart:= Memo1.SelStart +
                     Memo1.SelLength + k - 1;
    Memo1.SelLength:= UTF8Length(str_UTF8);
   end
  else
  begin
    ShowMessage('Строка не найдена');
    Memo1.SelStart:= 0;
    Memo1.SelLength:= 0;
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  tfile: TStringList;
  str: string;
begin
  tfile:= TStringList.Create;
  tfile.LoadFromFile('File in Russian.txt');
  str:= tfile.Text;
  {$IFDEF WINDOWS}
    str:= SysToUTF8(str); // преобразование в кодировку UTF-8
  {$ENDIF}
  Memo1.Lines.Add(str);
  Memo1.SelStart:= 0;
  Memo1.SelLength:= 0;
  tfile.Free;
  Edit1.SetFocus;
end;

procedure TForm1.Memo1KeyPress(Sender: TObject; var Key: char);
begin
  if Key = #13 then
     Edit1.SetFocus;
     CyrillicSearch;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  CyrillicSearch;
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: char);
begin
  if Key = #13 then
  begin
    Key:= #0;
    CyrillicSearch;
  end;
end;

initialization
  {$I unit1.lrs}

end.

